<?php
//	http://localhost:81/psp/kara/
//  https://s10.pierson1.shop/psp/kara/

if(file_exists('D:\xampp\htdocs\vendor\autoload.php'))
	require 'D:\xampp\htdocs\vendor\autoload.php';
else
	require ROOT . '/app/Vendor/autoload.php';
			// ROOT = '/home/gzenrzjd/public_html/s5/psp'
//use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx as Writer;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as Reader;
use PhpOffice\PhpSpreadsheet\RichText\RichText as RichText; //RichTextAPIを使用
use PhpOffice\PhpSpreadsheet\Style;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;


use PhpOffice\PhpSpreadsheet\Writer\Pdf;


App::uses('AppController', 'Controller');
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');


class KaraController extends AppController {
	public $name = 'Kara';
	public $uses = array('Config', 'Store', 'Staff', 'User', 'RoomGroup', 'RoomInfo', 'Plan', 'CheckDT1', 
		'Member', 'RatePlan', 'CartDT7', 'CartORD', 'Bumon', 'MenuMSTR',);
		//array('Store', 'Bumon', 'MenuMSTR', 'MenuMOD', 'RoomGroup', 'RoomInfo', 
		//					'CheckDT1', 'Config', 'TopMenu',
	public $layout = 'kara';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_url = "";
	public $_path = WWW_ROOT;
	public $_server_name =  "";
	public $_server_name2 =  "";

	public $_room_no = "";
	public $_check_id = "";
	public $_store_id = 1;
	public $_cart_id = "";
	public $_order_no = "";

	public $_order_send_flag = NULL;
	public $_deliver_send = NULL;
	public $_order_time = NULL;
	public $_deliver_time = NULL;

	public $_checkin_time = NULL;
	public $_checkout_time = NULL;

	public $_menu_id = NULL;
	public $_menu_name = NULL;
	public $_room_use = NULL;

	public $_cat1 = NULL;
	public $_cat2 = NULL;
	public $_photo_no = NULL;

	public $_bumon_id = NULL;
	public $_cat2name = NULL;
	public $_cat2flag = NULL;
	public $_up_date = NULL;

	public $_open_time = NULL;
	public $_close_time = NULL;
	public $_page_pattern = 0;
	public $_max_room_no = 10;
	public $_staff_name = "";

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/psp/";
		$this->set('_dir', $this->_dir);
		
//		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->_url .= "https://".$_SERVER['SERVER_NAME'].$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

/********** MOD 2023/06/18 ******************************************************/
		$this->_server_name =  substr($_SERVER['SERVER_NAME'], 0, strpos($_SERVER['SERVER_NAME'], ".") );
		$this->_store_id = preg_replace('/[^0-9]/', '', $this->_server_name);
/********** MOD 2023/06/18 ******************************************************/

		if($this->_server_name == "s.")
			$this->_server_name = "s";

		$this->set('_store_id', $this->_store_id);
		$this->set('_server_name', $this->_server_name);

		$this->_server_name2 =  " (".$this->_server_name.")";
		$this->set('_server_name2', $this->_server_name2);

		$main_title = "から次郎".$this->_server_name2;
		$this->set('main_title', $main_title);
	}

	public function index(){
		$this->redirect(array('controller' => 'kara', 'action' => 'top'));
	}
	
///======================================================///
	public function top($msg = ""){
		$top_title = $this->session_proc();
		$main_title = "TOPメニュー".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";


/*
			$room_no_max = $this->Common->GetRoomNoMax();



  `id` int(11) NOT NULL,
  `check_id` varchar(50) DEFAULT NULL,
  `room_no` tinyint(4) NOT NULL DEFAULT 0,
  `over_flag` tinyint(4) NOT NULL DEFAULT 0 COMMENT '2 or 3 超過0分から',
  `leave_remain_time` int(11) NOT NULL DEFAULT 0 COMMENT '退室残り時間（分単位）',
  `entry_close_time` int(11) NOT NULL DEFAULT 0 COMMENT '入室時から閉店までの時間（分単位）',
  `people` tinyint(4) NOT NULL DEFAULT 0,
  `unit_price_kind` tinyint(4) NOT NULL DEFAULT 0 COMMENT '単価種類',
  `drink_free_kind` tinyint(4) NOT NULL DEFAULT 0 COMMENT '飲み放題種類',
  `drink_free_time` int(11) NOT NULL DEFAULT 0 COMMENT '飲み放題残り時間',
  `dt4_flag` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'DT4 flag',
  `staff_call` tinyint(4) NOT NULL DEFAULT 0,
  `staff_call_time` datetime DEFAULT NULL,
  `up_date` datetime NOT NULL DEFAULT current_timestamp(),
  `staff_id` tinyint(4) NOT NULL DEFAULT 0,
  `member_id` varchar(50) DEFAULT NULL,
  `plan_id` tinyint(4) NOT NULL DEFAULT 0


  `id` int(11) NOT NULL,
  `RoomID` int(11) NOT NULL DEFAULT 0,
  `GroupID` int(11) NOT NULL DEFAULT 0,
  `RoomName` varchar(30) DEFAULT NULL,
  `OrderNo` int(11) NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 0,

*/

		$staff_id = 0;

		$search['id'] = "";
		$search['RoomID'] = "";
		$search['GroupID'] = "";
		$search['RoomName'] = "";
		$search['OrderNo'] = "";
		$search['status'] = "";
		$staff_id = 0;

		$conditions = array();
		
		if($this->request->data){
			if(isset($this->request->data['Staff'])){
				$staff = $this->request->data['Staff'];
				if(isset($staff['id'])){
					$staff_id = $staff['id'];
					
				}else{
					$staff_id = 0;
				}
			}

			if(isset($this->request->data['RoomInfo'])){
				$search = $this->request->data['RoomInfo'];
				if($search['submit'] == "クリア"){
					$search['id'] = "";
					$search['RoomID'] = "";
					$search['status'] = "";
					$search['RoomName'] = "";
				}
				
				if(isset($search['id'])){
					$search['id'] = (int)mb_convert_kana($search['id'], "KVa");
					if($search['id']){
						$conditions['id'] = (int)$search['id'];
					}
				}else{
					$search['id'] = "";
				}

				if(isset($search['RoomID'])){
					if($search['RoomID']){
						$conditions['RoomID'] = (int)$search['RoomID'];
					}
				}else{
					$search['RoomID'] = "";
				}

				if(isset($search['RoomName'])){
					if($search['RoomName']){
						$conditions['RoomName like'] = '%'.$search['RoomName'].'%';
					}
				}else{
					$search['RoomName'] = "";
				}

				if(isset($search['status'])){
					if($search['status'] <> ""){
						$conditions['status'] = $search['status'];
					}
				}else{
					$search['status'] = "";
				}
			}
		}
//debug($conditions);
		$this->paginate = array(
			'RoomInfo' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 100,
				'order' => 'id', 		// desc
				'conditions' => $conditions,
				//'group' => array('flag', 'checkin_time'),
			), 
		);
//debug($search);
		$data = $this->paginate('RoomInfo');
//debug($data);
//exit();
		$this->set('data', $data);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array();
		$data1 = $this->CheckDT1->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data1', $data1);
//debug($data1);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data2 = $this->Staff->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data2', $data2);
//debug($data2);

		$this->set('staff_id', $staff_id);
		$_SESSION['staff_id'] = $staff_id;

		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$msg = "";
		$this->set('msg', $msg);
//debug($search);
	}
//  https://s10.pierson.shop/psp/kara/


///======================================================///
	public function top_edit($room_no, $check_id="", $DT1ID, $member_list=""){
		$top_title = $this->session_proc();
		$main_title = "入室状況".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";
		$msg = "";

//debug($member_list);
//exit();
		if($member_list){
//debug($member_list);
			list($people, $member_id) = $this->ConvMember_id($member_list);
//debug($people);
//debug($member_id);
//exit();
		}else{
			$member_list = "";
			$people = 0;
			$member_id = "";
		}

		if($this->request->data){
//debug($this->request->data);
//exit();
			if(isset($this->request->data['RoomInfo']['submit'])){
				$save_data = $this->request->data['RoomInfo'];
				if(strstr($save_data['submit'], "更新") and $save_data['id'] > 0){
					$ret = $this->RoomInfo->save($save_data);
					$this->redirect(array('controller' => 'kara', 'action' => 'top'));
				}
			}

			if(isset($this->request->data['CheckDT1']['submit'])){
				$save_data = $this->request->data['CheckDT1'];
				if(strstr($save_data['submit'], "更新") and $save_data['id'] > 0){
//debug($save_data);
//exit();
					$ret = $this->CheckDT1->save($save_data);
					$this->redirect(array('controller' => 'kara', 'action' => 'top'));
				}elseif(strstr($save_data['submit'], "削除") and $save_data['id'] > 0){
					$this->CheckDT1->delete($save_data['id']);
					$DT1ID = 0;

					$conditions = array('RoomID' => $room_no);
					$room_id = $this->RoomInfo->field("id", $conditions, array('id DESC'));
					$this->RoomInfo->set('id', $room_id);
					$this->RoomInfo->saveField('status', 0);
					$this->redirect(array('controller' => 'kara', 'action' => 'top'));
				}
			}
		}

		$conditions = array('RoomID' => $room_no);
		$room_id = $this->RoomInfo->field("id", $conditions, array('id DESC'));
		$conditions = array('id'=>$room_id);	//'check_id'=>$this->_check_id
		$order = array();	//ASC | DESC
		$data = $this->RoomInfo->find('first', array('conditions' => $conditions, 'order' => $order));
		$this->set('data', $data);
//debug($search);
		$this->set('DT1ID', $DT1ID);

		if($DT1ID > 0){
			$conditions = array('id'=>$DT1ID);	//'check_id'=>$this->_check_id
			$order = array();	//ASC | DESC
			$data1 = $this->CheckDT1->find('first', array('conditions' => $conditions, 'order' => $order));
//debug($data1);
			if($_SESSION['staff_id'] > 0){
				$data1['CheckDT1']['staff_id'] = $_SESSION['staff_id'];

				$this->CheckDT1->set('id', $DT1ID);
				$this->CheckDT1->saveField('staff_id', $_SESSION['staff_id']);
			}

		}else{
			$data1 = array();
		}
		$this->set('data1', $data1);
//debug($data1);


		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data2 = $this->Staff->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data2', $data2);
//debug($data2);

		if($DT1ID > 0){
			$conditions = array('id' => $DT1ID);
			$staff_id = $this->CheckDT1->field("staff_id", $conditions, array('id DESC'));
		}else{
			$staff_id = 0;
		}
		$this->set('staff_id', $staff_id);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array();
		$data3 = $this->RoomInfo->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data3', $data3);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data4 = $this->RatePlan->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data4', $data4);
//debug($data4);

		$this->set("people", $people);
		$this->set("member_id", $member_id);
		$this->set("member_list", $member_list);

		$this->set('error_msg', $error_msg);
		//$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);

		$this->set('room_no', $room_no);
		//$check_id = $data1['CheckDT1']['check_id']; 
		$this->set('check_id', $check_id);
//debug($people);
//debug($member_id);
//debug($member_list);
//exit();

//debug($data);
//debug($_SERVER['REQUEST_URI']);
//debug($_SERVER['SCRIPT_URI']);
//debug($_SERVER['SCRIPT_URL']);		//'/psp/kara/top_edit/1/20'
//debug($_SERVER['SCRIPT_NAME']);
//$a = explode("/", $_SERVER['SCRIPT_URL']);  $url1 = "/".$a[1]."/".$a[2]."/".$a[3]."/"; 	
//debug($url1);
//exit();
	}

	public function checkin($room_no=0, $check_id="", $DT1ID=0, $member_list=""){
		$top_title = $this->session_proc();
//debug($room_no);
//debug($check_id);
//debug($DT1ID);
//debug($member_list);
//exit();
		$main_title = "新規入室メニュー".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";
		$msg = "";
		
		$plan = 0;


		if($member_list){
//debug($member_list);
			list($people, $member_id) = $this->ConvMember_id($member_list);
//debug($people);
//debug($member_id);
//exit();
		}else{
			$member_list = "";
			$people = 0;
			$member_id = "";
		}

//debug($this->request->data);
		if($this->request->data){
			if(isset($this->request->data['CheckDT1']['submit'])){
				$save_data = $this->request->data['CheckDT1'];
				if(strstr($save_data['submit'], "新規")){
					$save_data['id']=NULL;
				
					$save_data['leave_remain_time'] = ($save_data['hour1'] * 60) + $save_data['minutes1'];
					$save_data['drink_free_time'] = ($save_data['hour1'] * 60) + $save_data['minutes1'];
					list($save_data['people'], $save_data['member_id']) = $this->ConvMember_id($save_data['member_list']);

					if($this->CheckDT1->save($save_data)){
						$DT1ID = $this->CheckDT1->getLastInsertID();
//debug($DT1ID);
//debug($save_data);
						$conditions = array('RoomID' => $room_no);
						$room_id = $this->RoomInfo->field("id", $conditions, array('id DESC'));
						$this->RoomInfo->set('id', $room_id);
						$this->RoomInfo->saveField('status', 1);	//入室

//						$this->redirect(array('controller' => 'kara', 'action' => 'top'));

						$_SESSION['staff_id'] = $save_data['staff_id'];
						$_SESSION['room_no'] = $save_data['room_no'];
						$_SESSION['people'] = $save_data['people'];
						$_SESSION['member_id'] = $save_data['member_id'];
						$_SESSION['member_list'] = $save_data['member_list'];
						$_SESSION['DT1ID'] = $DT1ID;
						$_SESSION['plan_id'] = $save_data['plan_id'];

//debug($_SESSION);
//exit();
						$this->redirect(array('controller' => 'kara', 'action' => 'top_edit', $room_no, $check_id, $DT1ID, $save_data['member_list'] ));
					}					
				}
			}elseif(isset($this->request->data['Member']['members'])){
				$member_list = $this->request->data['Member']['members'];
				
				list($people, $member_id) = $this->ConvMember_id($member_list);

/*				
				$members = explode('|', $member_list);
				$people = count($members);
				if($people > 0){
					for($i=0; $i<$people; $i++){
						list($member_no[$i], $name[$i]) = explode('・', $members[$i]);
						$conditions = array('member_no' => $member_no[$i]);
						$m_id[$i] = $this->Member->field("id", $conditions, array('id DESC'));
					}
					$member_id = implode(",", $m_id);
				}
*/

//debug($member_no);
//debug($name);
//debug($m_id);
//debug($member_id);
//exit();
			}
		}

		if($DT1ID > 0){
			$conditions = array('id'=>$DT1ID);	//'check_id'=>$this->_check_id
			$order = array();	//ASC | DESC
			$data1 = $this->CheckDT1->find('first', array('conditions' => $conditions, 'order' => $order));


/*
			if($_SESSION['staff_id'] > 0){
				$data1['CheckDT1']['staff_id'] = $_SESSION['staff_id'];

				$this->CheckDT1->set('id', $DT1ID);
				$this->CheckDT1->saveField('staff_id', $_SESSION['staff_id']);
			}
*/

		}else{
			$data1 = array();
		}


		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data2 = $this->Staff->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data2', $data2);
//debug($data2);

		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('RoomID' => $room_no);
		$data3 = $this->RoomInfo->find('first', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data3', $data3);
//debug($data3);


		$order = array('id' => 'ASC');	//ASC | DESC
		$conditions = array('flag' => 0);
		$data4 = $this->RatePlan->find('all', array('conditions'=>$conditions, 'order' => $order));
		$this->set('data4', $data4);
//debug($data4);


		if(isset($_SESSION['staff_id']))
			$staff_id = $_SESSION['staff_id'];
		else
			$staff_id = 0;
		$this->set('staff_id', $staff_id);

		$this->set('room_no', $room_no);
	
		$this->set("people", $people);
		$this->set("member_id", $member_id);
		$this->set("member_list", $member_list);
		$this->set('DT1ID', $DT1ID);
		$this->set('check_id', $check_id);
		$this->set('plan', $plan);

		$this->set('error_msg', $error_msg);
		//$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);

		$_SESSION['staff_id'] = $staff_id;
		$_SESSION['room_no'] = $room_no;
		$_SESSION['people'] = $people;
		$_SESSION['member_id'] = $member_id;
		$_SESSION['member_list'] = $member_list;
		$_SESSION['DT1ID'] = $DT1ID;
		$_SESSION['plan'] = $plan;

		$this->set('session', $_SESSION);

//debug($_SERVER['REQUEST_URI']);
//debug($_SERVER['SCRIPT_URI']);
//debug($_SERVER['SCRIPT_URL']);
//debug($_SERVER['SCRIPT_NAME']);
	}


	public function checkout($room_no=0, $check_id="", $DT1ID=0){
		$this->autoLayout = false;  // レイアウトをOFFにする
		$this->layout = 'kara';
		$top_title = $this->session_proc();
		$main_title = "退室";
		$error_msg = "";
	
		$conditions = array('RoomID' => $room_no);
		$room_id = $this->RoomInfo->field("id", $conditions, array('id DESC'));
		$this->RoomInfo->set('id', $room_id);
		$this->RoomInfo->saveField('status', 2);

		$conditions = array('id' => $DT1ID);
		$data = $this->CheckDT1->find("first", array("conditions"=>$conditions, "order"=>array('id DESC')));
		$this->CheckDT1->set('id', $DT1ID);

		$t0 = strtotime($data['CheckDT1']['up_date']);
		$t1 = strtotime(date("Y-m-d H:i:s"));
		$t2 = ($t1 - $t0)/60;
		$t3 = floor($t2);
//debug(date("Y-m-d H:i:s", $t0));
//debug(date("Y-m-d H:i:s", $t1));
//debug($t2);
//debug($t3);
//exit();
		$this->CheckDT1->saveField('leave_remain_time', $t3);

		if($data['CheckDT1']['drink_free_kind']){
			//$this->CheckDT1->saveField('drink_free_time', $data['CheckDT1']['up_date']);
		}

		$this->CheckDT1->saveField('over_flag', 1);
		$this->CheckDT1->saveField('dt4_flag', 1);
//exit();
		//$this->redirect(array('controller' => 'kara', 'action' => 'top_edit', $room_no, $check_id, $DT1ID) );
		$this->redirect(array('controller' => 'kara', 'action' => 'top') );
	}

////================================================================================================
	public function clean($room_no, $check_id, $DT1ID){	//清掃完了
		$this->autoLayout = false;  // レイアウトをOFFにする
		//$this->layout = 'kara';
		$top_title = $this->session_proc();
		$main_title = "退室";
		$error_msg = "";
	
		$conditions = array('RoomID' => $room_no);
		$room_id = $this->RoomInfo->field("id", $conditions, array('id DESC'));
		$this->RoomInfo->set('id', $room_id);
		$this->RoomInfo->saveField('status', 0);

		$conditions = array('id' => $DT1ID);
		$data = $this->CheckDT1->find("first", array("conditions"=>$conditions, "order"=>array('id DESC')));
		$this->CheckDT1->set('id', $DT1ID);
		//$this->CheckDT1->saveField('leave_remain_time', "");

		if($data['CheckDT1']['drink_free_kind']){
			//$this->CheckDT1->saveField('drink_free_time', "");
		}

		$this->CheckDT1->saveField('over_flag', 0);
		$this->CheckDT1->saveField('dt4_flag', 0);
//exit();
		$_SESSION['DT1ID']=null;
		$DT1ID = null;
		$this->redirect(array('controller' => 'kara', 'action' => 'top', $room_no, $DT1ID) );	
	}

////================================================================================================
////================================================================================================

	public function checkdb($debug_room_no=0, $debug_unit_price_kind="", $debug_drink_free_kind=""){
//debug($debug_room_no);
//debug($debug_unit_price_kind);
//debug($debug_drink_free_kind);
		$main_title = "入退室管理".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		$search['id'] = "";
		$search['room_use'] = "";
		$search['room_no'] = "";
		$search['drink_free'] = "";

		$conditions = array();
		if($this->request->data){
//debug($this->request->data['Check']);
			$search = $this->request->data['CheckDT1'];
			if(strstr($search['submit'], "検索")){
				if($search['id'])
					$conditions['id'] = $search['id'];
				if(isset($search['room_use'])){
					if($search['room_use']){
						$conditions['dt4_flag'] = 0;
					}
				}else{
					$search['room_use'] = "";
				}
				if($search['room_no'])
					$conditions['room_no'] = $search['room_no'];

				if(isset($search['drink_free'])){
					if($search['drink_free']){
						$conditions['drink_free_kind >'] = 0;
					}
				}else{
					$search['drink_free'] = "";
				}
				//$conditions['MenuMSTR.menu_name like'] = '%'.$this->_menu_name.'%';
			}elseif(strstr($search['submit'], "クリア")){
				$search['id'] = "";
				$search['room_use'] = "";
				$search['room_no'] = "";
				$search['drink_free'] = "";
			}
		}
		
			
//debug($conditions);
		$this->paginate = array(
			'CheckDT1' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 20,
				'order' => 'room_no', 		// desc
				'conditions' => $conditions, 
				//'group' => array('room_no', 'checkin_time'),
			), 
		);
//debug($search);
		$data = $this->paginate('CheckDT1');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
//debug($data);
	}

	public function checkdb_edit($check_id=0){
		$main_title = "入退室管理編集".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		if($this->request->data){
			$check = $this->request->data['CheckDT1'];
			if($this->request->data['submit'] == "更新"){
//debug($this->request->data);
//debug($this->request->data['CheckDT1']);
//debug($check);
				if (isset($check['id'])){
					if($check['id'] > 0){
						$check_id = $check['id'];
						$ret = $this->CheckDT1->save($check);
					}
  				}
			}elseif($this->request->data['submit'] == "削除"){
				if (isset($check['id'])){
					if($check['id'] > 0){
						$check_id = $check['id'];
						$ret = $this->CheckDT1->delete($check_id);
						$this->redirect(array('controller' => 'kara', 'action' => 'check'));
					}
  				}
				$this->redirect(array('controller' => 'kara', 'action' => 'check'));
			}
			$check_id = $this->request->data['CheckDT1']['id'];
		}
//debug($check_id);
		if($check_id > 0){
			$conditions = array('id'=>$check_id);
			$data = $this->CheckDT1->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}





////================================================================================================
////================================================================================================
	public function order($room_no="", $check_id="", $DT1ID=0){	//カートリスト

//debug($room_no);
		$this->set('main_title', "注文管理(DT7)".$this->_server_name2);
		$error_msg = "";

		$conditions = $this->GetCartDT7RequestData($room_no, $check_id);
//debug($conditions);
//exit();
		$targetTime = $this->EvaluateTime("close");
		//$conditions['Cart.checkin_time >'] = date('Y-m-d H:i:s', strtotime("+1 hour", $targetTime));		//06:00
//debug($targetTime);
//exit();
//debug($conditions);
		//$conditions = array();
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'CartDT7' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('CartDT7.room_no', 'CartDT7.id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('CartDT7');
		$this->set('data', $data);
		$this->set('check_id', $check_id);
		$this->set('DT1ID', $DT1ID);
		

		$this->set('error_msg', $error_msg);
	}

	public function order_edit($order_id=0){
		$this->set('main_title', "注文管理(DT7)".$this->_server_name2);
		$error_msg = "";
//debug($this->request->data);

		if($this->request->data){
			$order = $this->request->data['CartDT7'];
			if(isset($order['id'])){
				$order_id = $order['id'];
				if(strstr($this->request->data['submit'], "更新")){
					if($order_id > 0){
//debug($save_array);
						$ret = $this->CartDT7->save($order);
					}
				}elseif(strstr($this->request->data['submit'], "削除")){
					$ret = $this->CartDT7->delete($order_id);
					$this->redirect(array('controller' => 'kara', 'action' => 'order'));
				}
			}
		}
//debug($order_id);
		if($order_id > 0){
			$conditions = array('id'=>$order_id);
			$data = $this->CartDT7->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
//debug($conditions);
//debug($data);
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}


	private function GetCartDT7RequestData($room_no=0, $check_id=""){
		$conditions = array();
//debug($this->request->data);
		if($this->request->data){
			$search = $this->request->data['CartDT7'];
//debug($conditions);

			if(strstr($search['submit'], "検索")){

				//$search = $this->request->data['CartDT7'];
//debug($search);

				if (isset($search['cart_id'])){
					if($search['cart_id'] > 0){
						$this->_cart_id = $search['cart_id'];
						$conditions['id'] = $this->_cart_id;
					}
				}
				if (isset($search['order_no'])){
					if($search['order_no'] > 0){
						$this->_order_no = $search['order_no'];
						$conditions['order_no'] = $this->_order_no;
					}
				}
				if (isset($search['room_no'])){
					if($search['room_no'] > 0){
						$this->_room_no = $search['room_no'];
						$conditions['room_no'] = $this->_room_no;
					}
				}
//debug($conditions['room_no']);
				if (isset($search['check_id'])){
					if($search['check_id'] <> ""){
						$this->_check_id = $search['check_id'];
						$conditions['check_id'] = $this->_check_id;
					}
				}

				if (isset($search['menu_name'])){
					if($search['menu_name'] != ""){
//debug($search);
						$this->_menu_name = $search['menu_name'];
						$conditions['menu_name like'] = '%'.$this->_menu_name.'%';
					}
				}
			}elseif(strstr($search['submit'], "クリア")){
				$this->_cart_id = NULL;
				$this->_order_no = NULL;
				if($room_no == 0)
					$this->_room_no = NULL;
				if($check_id == "")
					$this->_check_id = NULL;
				$this->_menu_name = NULL;
			}
		}
		
		if($room_no != 0){
			$this->_room_no = $room_no;
			$conditions['room_no'] = $this->_room_no;
		}
		if($check_id <> ""){
			$this->_check_id = $check_id;
			$conditions['check_id'] = $this->_check_id;
		}
		$this->set('cart_id', $this->_cart_id);
		$this->set('order_no', $this->_order_no);
		$this->set('room_no', $this->_room_no);
		$this->set('check_id', $this->_check_id);
		
		$this->set('menu_name', $this->_menu_name);
//debug($conditions);
		return $conditions;
	}

////================================================================================================
	public function cart($room_no="", $check_id="", $DT1ID=0){	//カートリスト
		$this->set('main_title', "カート管理(ORD)".$this->_server_name2);
		$error_msg = "";

		$conditions = $this->GetCartORDRequestData($room_no, $check_id);
		$targetTime = $this->EvaluateTime("close");
		//$conditions['CartORD.checkin_time >'] = date('Y-m-d H:i:s', strtotime("+1 hour", $targetTime));		//06:00

		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
//debug($conditions);
		$this->paginate = array(
			'CartORD' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('CartORD.room_no', 'CartORD.id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('CartORD');
		$this->set('data', $data);
		$this->set('room_no', $room_no);
		$this->set('check_id', $check_id);
		$this->set('DT1ID', $DT1ID);
//debug($conditions);
//debug($data);
		$this->set('error_msg', $error_msg);
	}

	public function cart_edit($order_id=0){
		$this->set('main_title', "カート管理(ORD)".$this->_server_name2);
		$error_msg = "";
//debug($this->request->data);

		if($this->request->data){
			$order = $this->request->data['CartORD'];
			if(isset($order['id'])){
				$order_id = $order['id'];
				if(strstr($this->request->data['submit'], "更新")){
					if($order_id > 0){
//debug($save_array);
						$ret = $this->CartORD->save($order);
					}
				}elseif(strstr($this->request->data['submit'], "削除")){
					$ret = $this->CartORD->delete($order_id);
					$this->redirect(array('controller' => 'kara', 'action' => 'cart'));
				}
			}
		}
//debug($order_id);
		if($order_id > 0){
			$conditions = array('id'=>$order_id);
			$data = $this->CartORD->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
//debug($conditions);
//debug($data);
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	private function GetCartORDRequestData($room_no, $check_id){
		$conditions = array();
		$conditions['deliver_send <'] = 2;
//debug($this->request->data);
		if($this->request->data){
			$search = $this->request->data['CartORD'];
//debug($conditions);

			if(strstr($search['submit'], "更新")){
				$savedata = $this->request->data;
//debug($savedata);
//debug(count($savedata));
//exit();
//debug($conditions);

				for($i=0; $i<count($savedata); $i++){
					if(isset($savedata[$i]['CartORD']['id'])){
//debug($savedata[$i]['CartORD']['id']);
						$this->CartORD->set('id', $savedata[$i]['CartORD']['id']);
						$this->CartORD->saveField('order_send_flag', $savedata[$i]['CartORD']['order_send_flag']);
						$this->CartORD->saveField('u_flag', $savedata[$i]['CartORD']['u_flag']);
						$this->CartORD->saveField('deliver_send', $savedata[$i]['CartORD']['deliver_send']);

						if($savedata[$i]['CartORD']['deliver_send'] == 1){
							$this->CartORD->saveField('deliver_send', 2);
							$conditions1 = array('id' => $savedata[$i]['CartORD']['id']);
							$data2 = $this->CartORD->find("first", array("conditions"=>$conditions1));	//, array('id DESC')

							$p = $data2['CartORD']['unit_price'] * $data2['CartORD']['qty'];	//料金合計

							//$data2['CartORD']['id'] = NULL;
							$data2['CartORD']['price'] = $p;	//金額
							$data2['CartORD']['total'] = $p;	//料金合計
							$data2['CartORD']['products'] = 1;	//商品明細点数
							$data2['CartORD']['room_charge'] = 0;	//室料

//debug($conditions1);
//debug($data2['CartORD']);
							$this->CartDT7->save($data2['CartORD']);
							//$this->CartORD->delete($savedata[$i]['CartORD']['id']);

						}
					}
				}//end of for
//exit();
//debug($conditions);

			
			}elseif(strstr($search['submit'], "クリア")){
				$this->_cart_id = NULL;
				$this->_room_no = NULL;
				$this->_check_id = NULL;
				$this->_menu_name = NULL;
				$this->_order_no = NULL;
				$this->_order_send_flag = NULL;
				$this->_deliver_send = NULL;
				
			}elseif(strstr($search['submit'], "検索")){
//debug($search);
				$conditions = array();
				if (isset($search['cart_id'])){
					if($search['cart_id'] > 0){
						$this->_cart_id = $search['cart_id'];
						$conditions['id'] = $this->_cart_id;
					}
				}
				if (isset($search['order_no'])){
					if($search['order_no'] > 0){
						$this->_order_no = $search['order_no'];
						$conditions['order_no'] = $this->_order_no;
					}
				}
				if (isset($search['room_no'])){
					if($search['room_no'] > 0){
						$this->_room_no = $search['room_no'];
						$conditions['room_no'] = $this->_room_no;
					}
				}
				if (isset($search['check_id'])){
					if($search['check_id'] <> ""){
						$this->_check_id = $search['check_id'];
						$conditions['check_id'] = $this->_check_id;
					}
				}

				if (isset($search['menu_name'])){
					if($search['menu_name'] != ""){
//debug($search);
						$this->_menu_name = $search['menu_name'];
						$conditions['menu_name like'] = '%'.$this->_menu_name.'%';
					}
				}

				if (isset($search['order_no'])){
					if($search['order_no'] != ""){
//debug($search);
						$this->_order_no = $search['order_no'];
						$conditions['order_no'] = $this->_order_no;
					}
				}
				if (isset($search['order_send_flag'])){
					if($search['order_send_flag'] != ""){
//debug($search);
						$this->_order_send_flag = $search['order_send_flag'];
						$conditions['order_send_flag'] = $this->_order_send_flag;
					}
				}
				if (isset($search['deliver_send'])){
					if($search['deliver_send'] != ""){
//debug($search);
						$this->_deliver_send = $search['deliver_send'];
						$conditions['deliver_send'] = $this->_deliver_send;
					}
				}
			}
		}
//debug($conditions);

		if($room_no != 0){
			$this->_room_no = $room_no;
			$conditions['room_no'] = $this->_room_no;
		}
		if($check_id <> ""){
			$this->_check_id = $check_id;
			$conditions['check_id'] = $this->_check_id;
		}

		$this->set('cart_id', $this->_cart_id);
		$this->set('room_no', $this->_room_no);
		$this->set('check_id', $this->_check_id);

		$this->set('order_no', $this->_order_no);
		$this->set('order_send_flag', $this->_order_send_flag);
		$this->set('deliver_send', $this->_deliver_send);
		
		$this->set('menu_name', $this->_menu_name);
//debug($conditions);
		return $conditions;
	}

	private function EvaluateTime($mode="close"){
		$open_time = $this->Store->field("open_time", array('id'=>1));
		$close_time = $this->Store->field("close_time", array('id'=>1));
//exit();
		if($mode=="open")
			$targetTime = strtotime(date("Y-m-d ".$open_time));
		else
			$targetTime = strtotime(date("Y-m-d ".$close_time));

		$time1 = new DateTime(date("H:i:s"));
		$time2 = new DateTime('00:00:00');
		$time3 = new DateTime($close_time);
		if(($time1 > $time2) and ($time1 < $time3))
			$targetTime = strtotime("-1 day", $targetTime);
		return $targetTime;
	}






/*
	public function order2($room_no="", $check_id="", $DT1ID=0){	//注文リスト
		//$this->autoLayout = false;  // レイアウトをOFFにする
		//$this->layout = 'kara';
		$top_title = $this->session_proc();

//debug($room_no);
//debug($check_id);
//debug($DT1ID);
		$main_title = "注文リスト";
		$error_msg = "";
		$msg = "";

		$search['id'] = "";
		$search['check_id'] = $check_id;
		$search['room_no'] = $room_no;
		$search['order_no'] = "";
		$search['menu_name'] = "";

		if($room_no > 0 and $check_id <> "")
			$conditions = array('room_no' => $room_no, 'check_id' => $check_id);
		else
			$conditions = array();
		if($this->request->data){

			if(isset($this->request->data['CartORD'])){
				$search = $this->request->data['CartORD'];
			}else{
				if($room_no > 0 and $check_id <> "")
					$conditions = array('room_no' => $room_no, 'check_id' => $check_id);
				else
					$search = array();
			}
//debug($search);
			if(isset($search['id'])){
				$search['id'] = (int)mb_convert_kana($search['id'], "KVa");
				if($search['id']){
					$conditions['id'] = (int)$search['id'];
				}
			}else{
				$search['id'] = "";
			}

			if(isset($search['room_no'])){
				if($search['room_no']){
					$conditions['room_no'] = $search['room_no'];
				}
			}else{
				$search['room_no'] = "";
			}

			if(isset($search['order_no'])){
				if($search['order_no']){
					$conditions['order_no'] = $search['order_no'];
				}
			}else{
				$search['order_no'] = "";
			}

			if(isset($search['menu_name'])){
				if($search['menu_name']){
					$conditions['menu_name'] = $search['menu_name'];
				}
			}else{
				$search['menu_name'] = "";
			}

		}

		$this->paginate = array(
			'CartORD' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 100,
				'order' => 'id', 		// desc
				'conditions' => $conditions,
				//'group' => array('flag', 'checkin_time'),
			), 
		);
		$data = $this->paginate('CartORD');
		$this->set('data', $data);
		$this->set('search', $search);

		$this->set('error_msg', $error_msg);
		//$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
	}

*/

/*
  `id` int(11) NOT NULL,
  `check_id` varchar(40) DEFAULT NULL,
  `room_no` tinyint(4) NOT NULL DEFAULT 0,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `menu_name` varchar(40) DEFAULT NULL,
  `qty` tinyint(4) NOT NULL DEFAULT 0,
  `unit_price` int(11) NOT NULL DEFAULT 0,
  `order_send_flag` tinyint(4) NOT NULL DEFAULT 0,
  `order_time` datetime NOT NULL DEFAULT current_timestamp(),
  `deliver_send` tinyint(4) NOT NULL DEFAULT 0,
  `deliver_time` datetime DEFAULT NULL,
  `r_flag` tinyint(4) NOT NULL DEFAULT 0,
  `s_flag` tinyint(4) NOT NULL DEFAULT 0,
  `t_flag` tinyint(4) NOT NULL DEFAULT 0,
  `u_flag` tinyint(4) NOT NULL DEFAULT 0,
  `drink_free_kind8` varchar(20) NOT NULL



  `leave_remain_time` int(11) NOT NULL DEFAULT 0 COMMENT '退室残り時間（分単位）',
  `drink_free_kind` tinyint(4) NOT NULL DEFAULT 0 COMMENT '飲み放題種類',
  `drink_free_time` int(11) NOT NULL DEFAULT 0 COMMENT '飲み放題残り時間',
  `dt4_flag` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'DT4 flag',
  `staff_call` tinyint(4) NOT NULL DEFAULT 0,
  `staff_call_time` datetime DEFAULT NULL,
  `up_date` datetime NOT NULL DEFAULT current_timestamp(),

///======================================================///
	public function staff($msg = ""){
		//$this->autoLayout = false;  // レイアウトをOFFにする
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$main_title = "担当者選択".$this->_server_name2;
		$error_msg = "";

		$search['id'] = "";
		$search['name'] = "";
		$search['flag'] = "";
		$search['up_date'] = "";

		$conditions = array();
		if($this->request->data){
			if($this->request->data['Staff']['submit'] == "更新"){
				$staffs = $this->request->data;
//debug(count($staffs));
				for($i=0; $i<count($staffs); $i++){
					if(isset($staffs[$i]['Staff']['id'])){
//debug($staffs[$i]['Staff']['id']);
						$this->Staff->set('id', $staffs[$i]['Staff']['id']);

						if(!isset($staffs[$i]['Staff']['flag'])){
							$staffs[$i]['Staff']['flag'] = 0;
							$this->Staff->saveField('flag', 0);
						}else{
							$staffs[$i]['Staff']['flag'] = 1;
							$this->Staff->saveField('flag', 1);
						}
					}
				}
			}
			
			if(isset($this->request->data['Staff'])){
				$search = $this->request->data['Staff'];
			}else{
				$search = array();
			}
//debug($search);

			if(isset($search['id'])){
				$search['id'] = (int)mb_convert_kana($search['id'], "KVa");
				if($search['id']){
					$conditions['id'] = (int)$search['id'];
				}
			}else{
				$search['id'] = "";
			}

			if(isset($search['name'])){
				if($search['name']){
					$conditions['name like'] = '%'.$search['name'].'%';
				}
			}else{
				$search['name'] = "";
			}

			if(isset($search['flag'])){
				if($search['flag'] == 1){
					$conditions['flag'] = 0;
				}
			}else{
				$search['flag'] = "";
			}

		}
		
			
//debug($conditions);
		$this->paginate = array(
			'Staff' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'id', 		// desc
				'conditions' => $conditions,
				//'group' => array('flag', 'checkin_time'),
			), 
		);
//debug($search);
		$data = $this->paginate('Staff');
//debug($data);
//exit();

		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

	public function staff_edit($staff_id = 0){
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$staff_name = "";
		$main_title = "担当者選択(Staff)".$this->_server_name2;

//debug($this->request->data);
		if($this->request->data){
			$staff = $this->request->data['Staff'];
//debug($staff);
//exit();
			if ($staff['submit'] == "削除"){
//debug($staff);
				$this->Staff->delete($staff['id']);
				$this->redirect(array('controller' => 'kara', 'action' => 'staff'));

			}
			if ($staff['submit'] == "更新" or strstr($staff['submit'], "新規")){
				if(!isset($staff['flag']))
					$staff['flag'] = 0;
				else
					$staff['flag'] = 1;
			}
			
			if ($staff['submit'] == "更新"){
				$staff['flag'] = mb_convert_kana($staff['flag'], "KVa");
				if($staff['id'] > 0){
					$staff_id = $staff['id'];
//debug($staff);
					$ret = $this->Staff->save($staff);
//exit();
					$this->redirect(array('controller' => 'kara', 'action' => 'staff'));
				}
			}elseif(strstr($staff['submit'], "新規")){
				$staff['flag'] = mb_convert_kana($staff['flag'], "KVa");
				$conditions = array('name like'=>$staff['name']);
				$data = $this->Staff->find('first', array('conditions'=>$conditions));
				if(count($data) == 0){
					$staff_id = $staff['id'] = null;
					$ret = $this->Staff->save($staff);
					$this->redirect(array('controller' => 'kara', 'action' => 'staff'));
				}
				$msg = $data['Staff']['name']."　は既にデータがあります";

			}else{
				debug("エラー");
				//exit();
			}

		}

		if($staff_id > 0){
			$conditions = array('id'=>$staff_id);
			$data = $this->Staff->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($staff_id > 0)
				$error_msg = "データがない";
		}
//debug($data);
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

*/


///======================================================///
	public function member($room_no=0, $check_id=0, $DT1ID=0, $member_list=""){
		//$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$main_title = "会員選択".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";
		$msg = $top_title;

		$search['id'] = "";
		$search['member_no'] = "";
		$search['name'] = "";
		$search['memo'] = "";
		$search['grade'] = "";
		$search['birthday'] = "";
		$search['expiration'] = "";
		$search['usage_amount'] = "";
		$search['visits'] = "";
		$search['last_visit'] = "";
		$search['point'] = "";
		$search['table1'] = "";
		$search['table2'] = "";
		$search['table3'] = "";
		$search['up_date'] = "";

		if(isset($_SESSION['member_list']) and $member_list==""){
			$member_list = $_SESSION['member_list'];
//debug($member_list);
		}

		$people = 0;
		$member_id = "";

//		$room_no = 0;
//		$DT1ID = 0;
		$plan = "";

		$conditions = array();
		if($this->request->data){
//debug($this->request->data);
//exit();
			if(isset($this->request->data['submit'])){
				if($this->request->data['submit'] == "更新"){
					$members = $this->request->data;
//debug($members);
					for($i=0; $i<count($members); $i++){
						if(isset($members[$i]['Member']['id'])){
//debug($members[$i]['Member']['id']);
							$this->Member->set('id', $members[$i]['Member']['id']);

							if(!isset($members[$i]['Member']['status'])){
								$members[$i]['Member']['status'] = 0;
								$this->Member->saveField('status', 0);
							}else{
								$members[$i]['Member']['status'] = 1;
								$this->Member->saveField('status', 1);
							}

							$this->Member->saveField('unit_price_kind', $members[$i]['Member']['unit_price_kind']);
						}
					}
				}elseif($this->request->data['submit'] == "検索"){
					$search = $this->request->data['Member'];
					if(isset($search['member_no'])){
						$search['member_no'] = mb_convert_kana($search['member_no'], "KVa");
						if($search['member_no']){
							$conditions['member_no'] = $search['member_no'];
						}
					}else{
						$search['member_no'] = "";
					}
					if(isset($search['name'])){
						if($search['name']){
							$conditions['name like'] = '%'.$search['name'].'%';
						}
					}else{
						$search['name'] = "";
					}

					if(isset($search['memo'])){
						if($search['memo']){
							$conditions['memo like'] = '%'.$search['memo'].'%';
						}
					}else{
						$search['memo'] = "";
					}

					if(isset($search['grade'])){
						if($search['grade']){
							$conditions['grade'] = $search['grade'];
						}
					}else{
						$search['grade'] = "";
					}

					if(isset($search['birthday'])){
						if($search['birthday']){
							$conditions['birthday like'] = '%'.$search['birthday'].'%';
						}
					}else{
						$search['birthday'] = "";
					}
//debug($search);
//debug($conditions);
//exit();
				}elseif($this->request->data['submit'] == "クリア"){
					$conditions = array();
					$search['member_no'] = "";
					$search['name'] = "";
					$search['grade'] = "";
					$search['birthday'] = "";
				}elseif($this->request->data['submit'] == "新規入室"){
//debug($this->request->data);
					$save_data = $this->request->data['CheckDT1'];
					$save_data['id']=NULL;
					$save_data['leave_remain_time'] = ($save_data['hour1'] * 60) + $save_data['minutes1'];
					$save_data['drink_free_time'] = ($save_data['hour1'] * 60) + $save_data['minutes1'];
					list($save_data['people'], $save_data['member_id']) = $this->ConvMember_id($save_data['member_list']);

					$a = explode(",", $save_data['member_id']);
					$save_data['unit_price_kind'] = $this->Member->field("MAX(unit_price_kind)", array('id'=>$a));
					$save_data['drink_free_kind'] = $this->RatePlan->field("drink_free_kind", array('id'=>$save_data['plan_id']));
					
					$time_offset = (int)$this->Common->GetStoreMsg("msg3", 4);
					$save_data['check_id'] = "s".dechex(strtotime($time_offset." minute").sprintf('%02d', $save_data['room_no']));
//debug($save_data);
//exit();
					if($this->CheckDT1->save($save_data)){
						$DT1ID = $this->CheckDT1->getLastInsertID();

						$conditions = array('RoomID' => $save_data['room_no']);
						$room_id = $this->RoomInfo->field("id", $conditions, array('id DESC'));
						$this->RoomInfo->set('id', $room_id);
						$this->RoomInfo->saveField('status', 1);

						$this->redirect(array('controller' => 'kara', 'action' => 'top_edit', $save_data['room_no'], $save_data['check_id'], $DT1ID, $save_data['member_list'] ));
					}					
				}
			}
		}

//debug($conditions);
//exit();
		$this->paginate = array(
			'Member' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'name', 		// desc
				'conditions' => $conditions, 
			), 
		);
//debug($search);
		$data = $this->paginate('Member');
		$this->set('data', $data);

		$conditions = array();	//'check_id'=>$this->_check_id
		$order = array('member_no' => 'ASC');	//ASC | DESC
		$data1 = $this->Member->find('all', array('conditions' => $conditions, 'order' => $order));
		$this->set('data1', $data1);

		$conditions = array('flag' => 0);	//'check_id'=>$this->_check_id
		$order = array('id' => 'ASC');	//ASC | DESC
		$data2 = $this->Staff->find('all', array('conditions' => $conditions, 'order' => $order));
		$this->set('data2', $data2);

		$conditions = array('status' => 0);	//'check_id'=>$this->_check_id
		$order = array('RoomID' => 'ASC');	//ASC | DESC
		$data3 = $this->RoomInfo->find('all', array('conditions' => $conditions, 'order' => $order));
		$this->set('data3', $data3);

		$conditions = array('flag' => 0);	//'check_id'=>$this->_check_id
		$order = array('id' => 'ASC');	//ASC | DESC
		$data4 = $this->RatePlan->find('all', array('conditions' => $conditions, 'order' => $order));
		$this->set('data4', $data4);

		$this->set('error_msg', $error_msg);
		$this->set('search', $search);
		$this->set('top_title', $top_title);

		$this->set('main_title', $main_title);
		$this->set('msg', $msg);

		$this->set("people", $people);
		$this->set("member_id", $member_id);
		
		$_SESSION['member_list'] = $member_list;
		$this->set("member_list", $member_list);
//debug($member_list);
		$this->set('room_no', $room_no);
		$this->set('DT1ID', $DT1ID);
		$this->set('check_id', $check_id);
		$this->set('plan', $plan);
//debug($data);
//exit();
	}	

	public function member_edit($member_id=0){
		//$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$room_name = "";
		$main_title = "会員選択(Member)".$this->_server_name2;

		if($this->request->data){
			$member = $this->request->data['Member'];
//debug($member);
//exit();
			if ($member['submit'] == "削除"){
				$member_id = $member['id'];
				if($member['id'] > 0){
					$ret = $this->Member->delete($member_id);
					$this->redirect(array('controller' => 'kara', 'action' => 'member'));
				}
			}

			$flag = 0;
			$error_msg = "";
			if($member['submit'] == "更新" or $member['submit'] == "新規追加"){
				if(strlen($member['member_no2']) <> "")
					$member['member_no'] = $member['member_no2'];
				if(strlen($member['grade2']) <> "")
					$member['grade'] = $member['grade2'];
				if(!isset($discount['status']))
					$member['status'] = 0;
				else
					$member['status'] = 1;
//debug($member);
//exit();
				if(strlen($member['member_no']) == 0){
					$error_msg .= "※会員番号が空白です。";
					$flag = 1;
				}

				if(strlen($member['name']) == 0){
					$error_msg .= "※会員名が空白です。";
					$flag = 1;
				}
				if(strlen($member['grade']) == 0){
					$error_msg .= "※グレードが空白です。";
					$flag = 1;
				}


				
			}
			
			if ($member['submit'] == "更新"){
				$member['status'] = mb_convert_kana($member['status'], "KVa");
				if($member['id'] > 0){
					$member_id = $member['id'];
//debug($member);
					$ret = $this->Member->save($member);
					$this->redirect(array('controller' => 'kara', 'action' => 'member'));
				}
			}elseif ($member['submit'] == "新規"){
//debug($member);
				$conditions = array('name'=>$member['name'], 'birthday'=>$member['birthday']);
				$data = $this->Member->find('first', array('conditions'=>$conditions));
				if(count($data) > 0){
					$error_msg .= "※同名の会員登録があります。";
					$flag = 1;
				}

				$conditions = array('member_no'=>$member['member_no']);
				$data = $this->Member->find('first', array('conditions'=>$conditions));
				if(count($data) > 0){
					$error_msg .= "※同じ会員番号の会員登録があります。";
					$flag = 1;
				}


				if($flag == 0){
					$member['id'] = NULL;
					$ret = $this->Member->save($member);
					$this->redirect(array('controller' => 'kara', 'action' => 'member'));
				}
				$member_id = "";
			}elseif ($member['submit'] == "キャンセル"){
					$this->redirect(array('controller' => 'kara', 'action' => 'member'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Room");	//'

		if($member_id > 0){
			$conditions = array('id'=>$member_id);
			$data = $this->Member->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($member_id > 0)
				$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);	
	}

/** ============================================================================================================= */
	public function download_member(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_Member.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'Member'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','会員番号','会員名','メモ','グレード','誕生日','有効期限',
			'利用金額','来店回数','最終来店日','ポイント',
			'テーブル1','テーブル2','テーブル3','状態','単価種類','更新日時');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->Member->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}

/** ============================================================================================================= */
	public function upload_member(){		//EXCELL UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/Member/Member.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','member_no','name','memo','grade','birthday','expiration','usage_amount',
							'visits','last_visit','point','table1','table2','table3','status','unit_price_kind','up_date');
					
					$data = $this->ReadExcell($file_path, $fields);

					$this->Member->truncate();
					$this->Member->saveAll($data);
					$this->redirect(array('controller' => 'config2', 'action' => 'member'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}




///======================================================///

	public function plan($msg = ""){
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$main_title = "料金選択".$this->_server_name2;
		$this->set('main_title', $main_title);
		$error_msg = "";

		$search['id'] = "";
		$search['plan'] = "";
		$search['comment'] = "";
		$search['flag'] = "";
		$search['up_date'] = "";

		$conditions = array();
		if($this->request->data){
//debug($this->request->data['RatePlan']);
			$search = $this->request->data['RatePlan'];
			if(isset($search['id'])){
				if($search['id']){
					$conditions['id'] = $search['id'];
				}
			}else{
				$search['id'] = "";
			}
			if(isset($search['plan'])){
				if($search['plan']){
					$conditions['plan like'] = '%'.$search['plan'].'%';
				}
			}else{
				$search['plan'] = "";
			}

			if(isset($search['comment'])){
				if($search['comment']){
					$conditions['comment like'] = '%'.$search['comment'].'%';
				}
			}else{
				$search['comment'] = "";
			}
			if(isset($search['flag'])){
				if($search['flag'] == 1){
					$conditions['flag'] = 0;
				}
			}else{
				$search['flag'] = "";
			}

		}
		
			
//debug($conditions);
//exit();
		$this->paginate = array(
			'RatePlan' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 50,
				'order' => 'id', 		// desc
				'conditions' => $conditions, 
				//'group' => array('flag', 'checkin_time'),
			), 
		);
		$data = $this->paginate('RatePlan');
		$this->set('data', $data);
//debug($search);
		$this->set('error_msg', $error_msg);
		$this->set('search', $search);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);
	}

	public function plan_edit($plan_id=0){
		$this->layout = 'kara1';
		$top_title = $this->session_proc();
		$error_msg = "";
		$msg = "";
		$room_name = "";
		$main_title = "プラン選択(RatePlan)".$this->_server_name2;

		if($this->request->data){
			$plan = $this->request->data['RatePlan'];
//debug($plan);
//exit();
			if ($plan['submit'] == "削除"){
//debug($plan);
				$this->RatePlan->delete($plan['id']);
				$this->redirect(array('controller' => 'kara', 'action' => 'plan'));

			}elseif ($plan['submit'] == "更新"){
				$plan['flag'] = mb_convert_kana($plan['flag'], "KVa");
				if($plan['id'] > 0){
					$plan_id = $plan['id'];
//debug($plan);
					$ret = $this->RatePlan->save($plan);
					$this->redirect(array('controller' => 'kara', 'action' => 'plan'));
				}
			}elseif ($plan['submit'] == "新規"){
//debug($plan);
				$plan['flag'] = mb_convert_kana($plan['flag'], "KVa");
				if(!$plan['plan']){
					$msg = "プラン名がありません";
				}else{
					$conditions = array('plan'=>$plan['plan']);
					$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
					if(count($data) == 0){
						$plan['id'] = null;
						$ret = $this->RatePlan->save($plan);
						$this->redirect(array('controller' => 'kara', 'action' => 'plan'));
					}
					$msg = $data['RatePlan']['plan']."　は既にデータがあります";
				}
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Room");	//'

		if($plan_id > 0){
			$conditions = array('id'=>$plan_id);
			$data = $this->RatePlan->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			if($plan_id > 0)
				$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
		$this->set('top_title', $top_title);
		$this->set('main_title', $main_title);
		$this->set('msg', $msg);
//debug($data);	
	}


/** ============================================================================================================= */
	public function bumon(){
//debug(ROOT);
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "メニュー管理(Bumon)".$this->_server_name2);
		$conditions = $this->GetBumonRequestData();
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		if(isset($this->request->data['submit'])){
			if($this->request->data['submit'] == "更新"){
				$bumons = $this->request->data;
				for($i=0; $i<count($bumons); $i++){
					if(isset($bumons[$i]['Bumon']['id'])){
						$this->Bumon->set('id', $bumons[$i]['Bumon']['id']);
						if(!isset($bumons[$i]['Bumon']['cat2flag'])){
							$bumons[$i]['Bumon']['cat2flag'] = 0;
							$this->Bumon->saveField('cat2flag', 0);
						}else{
							$bumons[$i]['Bumon']['cat2flag'] = 1;
							$this->Bumon->saveField('cat2flag', 1);
						}

						if(!isset($bumons[$i]['Bumon']['flag16'])){
							$bumons[$i]['Bumon']['flag16'] = 0;
							$this->Bumon->saveField('flag16', 0);
						}else{
							$bumons[$i]['Bumon']['flag16'] = 1;
							$this->Bumon->saveField('flag16', 1);
						}
					}


/*
					if(isset($bumons[$i]['Bumon']['id'])){
//debug($bumons[$i]['Bumon']['id']);
						$this->Bumon->set('id', $bumons[$i]['Bumon']['id']);
						if(isset($bumons[$i]['Bumon']['flag16'])){
							if($bumons[$i]['Bumon']['flag16'] == 1){
								$this->Bumon->saveField('flag16', 1);
								continue;
							}
						}
						$this->Bumon->saveField('flag16', 0);
					}
*/
				}//end of for
			}
		}
		if(isset($bumons[1]['Bumon']['current'])){
			$page = $bumons[1]['Bumon']['current'];
		}else{
			$page = 1;
		}

		$this->set('page', $page);

		$this->paginate = array(
			'Bumon' => array(
				'page' => 1,
				'limit' => 20,
				'order' => 'Bumon.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Bumon');
		$this->set('data', $data);

		//**********************
		$fields = array('cat1');
		$conditions = array();
		$group = array('cat1');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat1_array[$i] = $menu[$i]['MenuMSTR']['cat1'];
			$this->set('cat1_array', $cat1_array);
		}
		//$cat1_array = array("DRINK","FOOD");
		//**********************

		//**********************
		$fields = array('cat2');
		if(isset($search['cat1'])){
			if($search['cat1'])
				$conditions = array('cat1' => $search['cat1']);
		}else
			$conditions = array();
		$group = array('cat2');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat2_array[$i] = $menu[$i]['MenuMSTR']['cat2'];
			$this->set('cat2_array', $cat2_array);
		}
		//**********************
		
		$this->set('error_msg', $error_msg);

		if($page > 1)
			return $this->redirect(['action' => 'bumon', "page:".$page]);
	}

	private function GetBumonRequestData(){
		$conditions = array();
//debug($this->request->data);
		if ($this->request->data){
		  if(isset($this->request->data['Bumon'])){
			$search = $this->request->data['Bumon'];
			if(strstr($search['submit'], "検索")){
				if (isset($search['bumon_id'])){
					if($search['bumon_id'] > 0){
						$this->_bumon_id = $search['bumon_id'];
						$conditions['Bumon.id'] = $this->_bumon_id;
					}
				}
				if (isset($search['cat1'])){
					if($search['cat1']){
						$this->_cat1 = $search['cat1'];
						$conditions['Bumon.cat1 like'] = $this->_cat1;
					}
				}
				if (isset($search['cat2'])){
					if($search['cat2']){
						$this->_cat2 = $search['cat2'];
						$conditions['Bumon.cat2 like'] = $this->_cat2;
					}
				}
				if (isset($search['cat2name'])){
					if($search['cat2name']){
						$this->_cat2name = $search['cat2name'];
						$conditions['Bumon.cat2name like'] = '%'.$this->_cat2name.'%';
					}
				}
				if (isset($search['cat2flag'])){
					if($search['cat2flag']){
						$this->_cat2flag = $search['cat2flag'];
						$conditions['Bumon.cat2flag like'] = '%'.$this->_cat2flag.'%';
					}
				}
			}elseif(strstr($search['submit'], "クリア")){
				$this->_bumon_id = NULL;
				$this->_cat2name = NULL;
				$this->_cat1 = NULL;
				$this->_cat2 = NULL;
				$this->_cat2flag = NULL;
			}
		  }
		}
		$this->set('bumon_id', $this->_bumon_id);
		$this->set('cat2name', $this->_cat2name);
		$this->set('cat1', $this->_cat1);
		$this->set('cat2', $this->_cat2);
		$this->set('cat2flag', $this->_cat2flag);
//debug($conditions);
		return $conditions;
	}

	public function bumon_edit($bumon_id=0){
		$error_msg = "";
		$this->set('main_title', "メニュー管理(Bumon)".$this->_server_name2);
//debug($this->request->data);
		if($this->request->data){
			$bumon = $this->request->data['Bumon'];
//debug($bumon);
			if ($bumon['submit'] == "削除"){
				//$this->Bumon->delete($bumon['id']);
				$this->redirect(array('controller' => 'kara', 'action' => 'bumon'));

			}elseif ($bumon['submit'] == "更新"){
				if($bumon['id'] > 0){
					if(!isset($bumon['cat2flag']))
						$bumon['cat2flag'] = 0;
					else
						$bumon['cat2flag'] = 1;
					if(!isset($bumon['flag16']))
						$bumon['flag16'] = 0;
					else
						$bumon['flag16'] = 1;

					$bumon_id = $bumon['id'];
//debug($bumon);
					$ret = $this->Bumon->save($bumon);
				}
				$this->redirect(array('controller' => 'kara', 'action' => 'bumon'));
			}else{
				debug("エラー");
				//exit();
			}

		}
		//$new_id = $this->Common->ResetModelID("Bumon");	//'

		if($bumon_id > 0){
			$conditions = array('id'=>$bumon_id);
			$data = $this->Bumon->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	public function bumon_img($bumon_id=0){
		$error_msg = "";
		$this->set('main_title', "メニュー管理(部門)".$this->_server_name2);

		if($this->request->data){
//debug($this->request->data);			
			$bumon_id = $this->request->data['Bumon']['id'];
			$cat1_no = $this->request->data['Bumon']['cat1'];
			$cat2_no = $this->request->data['Bumon']['cat2'];
			$photo_no = $this->request->data['Bumon']['photo_no'];
			$img_file = $this->request->data['Bumon']['img_file'];
			$img_file_tmp = $this->request->data['Bumon']['img_file_tmp'];

			if(strstr($this->request->data['submit'], "写真をアップする")){
				if ($this->request->is('post')) {
//debug($this->request->data['Post']);
//画像の保存
					//画像保存先のパス
					$path = IMAGES;
					$image = $this->request->data['Post']['image'];
//debug($image);
					move_uploaded_file($image['tmp_name'], $img_file_tmp);		//$image['name']
					$this->ImageResize($img_file_tmp, $img_file, 1010, 384);

					$this->Bumon->set('id', $bumon_id);
					$this->Bumon->saveField('up_date', date("Y-m-d H:i:s"));

				}
			}
		}
//debug($bumon_id);
		if($bumon_id > 0){
			$conditions = array('id'=>$bumon_id);
			$data = $this->Bumon->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

	private function ImageResize($img_src, $img_des, $width_des=1010, $height_des=384){
		list($width, $hight) = getimagesize($img_src); // 元の画像名を指定してサイズを取得
		$baseImage = imagecreatefromjpeg($img_src); // 元の画像から新しい画像を作る準備
		$image = imagecreatetruecolor($width_des, $height_des); // サイズを指定して新しい画像のキャンバスを作成
		
		//$transparent = imagecolorallocatealpha($image, 0, 0, 0, 0); // 透明度を持つ色を作成
		$white = imagecolorallocate( $image, 255, 255, 255 );
		imagefill($image, 0, 0, $white);    // 塗りつぶす

		$width_des2 = $height_des * ($width/$hight);

		if($width_des > 577)
			$x_des = ($width_des - $width_des2) / 4;	// master の左オフセット
		else
			$x_des = ($width_des - $width_des2) / 2;	// bumon の左オフセット
		// 画像のコピーと伸縮
		imagecopyresampled($image, $baseImage, $x_des, 0, 0, 0, $width_des2, $height_des, $width, $hight);

		// コピーした画像を出力する
		imagejpeg($image , $img_des);
//debug($img_src);
//debug($img_des);
//exit();
		return;
		
		
		//resizeimg.classを読み込む
		App::import('Vendor', 'ResizeimgClass', array('file' => 'Resize' . DS . 'resizeimg.class.php'));
		$RI = new resize_image();   //クラスの作成
		
   		$save_path = $img_file;  //保存される画像のパス
   		$resize_path = $img_file;  //resizeimg.class.phpから見た画像ファイルへのパス

		//画像の作成(縦・横最大640px)
		//画像縦横サイズを取得
		$wh_size = getimagesize($resize_path);
		$w = $wh_size[0];  // width
		$h = $wh_size[1];    //height
		if ($w >= $h){
			//$width = $width_no;
			//$height = 'auto';
			$type = 'wfit';
		}else{
			//$width = 'auto';
			//$height = 384;
			$type = 'hfit';
		}
		$resize_image = $RI->disp_resize_img_path($resize_path, $width, $height, $type);
		//画像をリサイズしたら元の画像を削除
		//$file = new File($save_path);
		//$file->delete();
	}


/*************************************************************************************************/

	public function menu(){
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);
//debug($this->request->data);
		if(isset($this->request->data['submit'])){
			if($this->request->data['submit'] == "更新"){
				$menus = $this->request->data;
//debug(count($menus));
				for($i=0; $i<count($menus); $i++){
					if(isset($menus[$i]['MenuMSTR']['id'])){
//debug($menus[$i]['MenuMSTR']['id']);
						$this->MenuMSTR->set('id', $menus[$i]['MenuMSTR']['id']);
						if(!isset($menus[$i]['MenuMSTR']['menu_flag'])){
							$menus[$i]['MenuMSTR']['menu_flag'] = 0;
							$this->MenuMSTR->saveField('menu_flag', 0);
						}else{
							$menus[$i]['MenuMSTR']['menu_flag'] = 1;
							$this->MenuMSTR->saveField('menu_flag', 1);
						}
					}
				}
			}
		}
		if(isset($menus[1]['MenuMSTR']['current'])){
			$page = $menus[1]['MenuMSTR']['current'];
		}else{
			$page = 1;
		}
		

		$conditions = $this->GetMenuRequestData();

		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'MenuMSTR' => array(
				'page' => 1,
				'limit' => 100,
				'order' => 'MenuMSTR.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('MenuMSTR');
		$this->set('data', $data);

		//**********************
		$fields = array('cat1');
		$conditions = array();
		$group = array('cat1');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat1_array[$i] = $menu[$i]['MenuMSTR']['cat1'];
			$this->set('cat1_array', $cat1_array);
		}
		//$cat1_array = array("DRINK","FOOD");
		//**********************

		//**********************
		$fields = array('cat2');
		if(isset($search['cat1'])){
			if($search['cat1'])
				$conditions = array('cat1' => $search['cat1']);
		}else
			$conditions = array();
		$group = array('cat2');
		$orders = array('id');
		$menu = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$cat2_array[$i] = $menu[$i]['MenuMSTR']['cat2'];
			$this->set('cat2_array', $cat2_array);
		}
		//**********************

		$this->set('error_msg', $error_msg);
		


/*
$this->Paginator->numbers(array(
'first' => '', //ページ数が多いとき最初のページを出すか（数字で指定）
'last' => '',//ページ数が多いとき最後のページを出すか（数字で指定）
'before'=>'',//ページ番号の前に出力する文字を指定
'after'=>'',//ページ番号の後に出力する文字を指定
'modulus'=>'',//ページ番号を幾つ表示するか（デフォルト値：8）
'separator'=>'',//ページ番号を区切る文字列（デフォルト値：|）
'ellipsis'=>'',//省略される時に表示される文字列（デフォルト値：・・・）
'tag'=>'',//ページ番号を囲むタグ（デフォルト値：設定無し）
'class'=>'',//上記タグのクラス名を設定（デフォルト値：設定無し）
'currentTag'=>'',//表示中のページ番号のタグを設定（デフォルト値：null）
'currentClass'=>'',//表示中のページ番号のクラスを設定（デフォルト値：current）
)
);
*/
	}



	private function GetMenuRequestData(){
		$conditions = array();
//debug($this->request->data);
		if (isset($this->request->data['MenuMSTR'])){
			$search = $this->request->data['MenuMSTR'];

			if(strstr($search['submit'], "検索")){
				if (isset($search['order_no'])){
					if($search['order_no'] > 0){
						$this->_order_no = $search['order_no'];
						$conditions['MenuMSTR.order_no'] = $this->_order_no;
					}
				}
				if (isset($search['menu_id'])){
					if($search['menu_id'] > 0){
						$this->_menu_id = $search['menu_id'];
						$conditions['MenuMSTR.id'] = $this->_menu_id;
					}
				}
				if (isset($search['cat1'])){
					if($search['cat1']){
						$this->_cat1 = $search['cat1'];
						$conditions['MenuMSTR.cat1 like'] = $this->_cat1;
					}
				}
				if (isset($search['cat2'])){
					if($search['cat2']){
						$this->_cat2 = $search['cat2'];
						$conditions['MenuMSTR.cat2 like'] = $this->_cat2;
					}
				}
				if (isset($search['menu_name'])){
					if($search['menu_name']){
						$this->_menu_name = $search['menu_name'];
						$conditions['MenuMSTR.menu_name like'] = '%'.$this->_menu_name.'%';
					}
				}
				if (isset($search['photo_no'])){
					if($search['photo_no']){
						$this->_photo_no = $search['photo_no'];
						$conditions['MenuMSTR.photo_no like'] = '%'.$this->_photo_no.'%';
					}
				}
			}elseif(strstr($search['submit'], "クリア")){
				$this->_order_no = NULL;
				$this->_menu_id = NULL;
				$this->_menu_name = NULL;
				$this->_cat1 = NULL;
				$this->_cat2 = NULL;
				$this->_photo_no = NULL;
			}
		}
		$this->set('order_no', $this->_order_no);
		$this->set('menu_id', $this->_menu_id);
		$this->set('menu_name', $this->_menu_name);
		$this->set('cat1', $this->_cat1);
		$this->set('cat2', $this->_cat2);
		$this->set('photo_no', $this->_photo_no);
//debug($conditions);
		return $conditions;
	}



	public function menu_edit($menu_id=0){
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

		if($this->request->data){
			if($this->request->data['submit'] == "更新"){
//debug($this->request->data);
//debug($this->request->data['MenuMSTR']);
				$menu = $this->request->data['MenuMSTR'];
				if (isset($menu['id'])){
					if($menu['id'] > 0){
						if(!isset($menu['menu_flag']))
							$menu['menu_flag'] = 0;
						else
							$menu['menu_flag'] = 1;

						$menu_id = $menu['id'];
						$ret = $this->MenuMSTR->save($menu);
						$this->redirect(array('controller' => 'kara', 'action' => 'menu'));
					}
  				}
			}
			$menu_id = $this->request->data['MenuMSTR']['id'];
			$cat1_no = $this->request->data['MenuMSTR']['cat1'];
			$cat2_no = $this->request->data['MenuMSTR']['cat2'];

			if(strstr($this->request->data['submit'], "アップロード")){
				if ($this->request->is('post')) {
//debug($this->request->data['Post']);
					$post = $this->request->data['Post']['image'];
					$tmp=$post['tmp_name'];
//debug($tmp);
					if(is_uploaded_file($tmp)) {
/*						$file_name = basename($post['name']);
						if(strstr($this->request->data['submit'], "商品"))
							$file = WWW_ROOT.'img'.DS."1".DS.'item'.DS.$cat1_no.DS.$file_name;
						elseif(strstr($this->request->data['submit'], "カテゴリ2"))
							$file = WWW_ROOT.'img'.DS."1".DS.'mcate'.DS.$cat1_no.DS.$cat2_no.".jpg";
						elseif(strstr($this->request->data['submit'], "カテゴリ1"))
							$file = WWW_ROOT.'img'.DS."1".DS.'lcate'.DS.$cat1_no.".jpg";
						elseif(strstr($this->request->data['submit'], "ページHEADER"))
							$file = WWW_ROOT.'img'.DS."1".DS.'main'.DS."header.jpg";
						elseif(strstr($this->request->data['submit'], "ページTOP"))
							$file = WWW_ROOT.'img'.DS."1".DS.'main'.DS."main.jpg";
						else
							debug("");
//debug($file);
						if (move_uploaded_file($tmp, $file)) {
							if(strstr($this->request->data['submit'], "商品")){
								$this->MenuMSTR->set('id', $menu_id);
								$this->MenuMSTR->saveField('photo_no', $file_name);
							}
						}else{
							debug("Upload Error");
							$error_msg = "Upload Error";
						}
*/
					}
				}
			}
		}
//debug($menu_id);
		if($menu_id > 0){
			$conditions = array('id'=>$menu_id);
			$data = $this->MenuMSTR->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}


	public function menu_img($menu_id=0){		//画像UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

		if($this->request->data){
//debug($this->request->data);			
			$menu_id = $this->request->data['MenuMSTR']['id'];
			$cat1_no = $this->request->data['MenuMSTR']['cat1'];
			$cat2_no = $this->request->data['MenuMSTR']['cat2'];
			$photo_no = $this->request->data['MenuMSTR']['photo_no'];
			$img_file = $this->request->data['MenuMSTR']['img_file'];
			$img_file_tmp = $this->request->data['MenuMSTR']['img_file_tmp'];

			if(strstr($this->request->data['submit'], "写真をアップする")){
				if ($this->request->is('post')) {
//debug($this->request->data['Post']);
//画像の保存
					//画像保存先のパス
					$path = IMAGES;
					$image = $this->request->data['Post']['image'];
//debug($image);
					move_uploaded_file($image['tmp_name'], $img_file_tmp);		//$image['name']
					$this->ImageResize($img_file_tmp, $img_file, 576, 384);

					$this->MenuMSTR->set('id', $menu_id);
					$this->MenuMSTR->saveField('up_date', date("Y-m-d H:i:s"));

				}
			}
		}
//debug($menu_id);
		if($menu_id > 0){
			$conditions = array('id'=>$menu_id);
			$data = $this->MenuMSTR->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}



	public function download_menu(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_MenuMSTR.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'MenuMSTR'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','注文番号','カテゴリ1','カテゴリ2','写真ファイル番号','メニュー名','単価1',
			'単価2','単価3','単価4','単価5','単価6','単価7','単価8','単価9','単価10',
			'飲み放題種類','販売状態','flag16','更新日時');



		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->MenuMSTR->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}

	//https://s5.oierson1.shop/psp/kara/download
	public function download_bumon(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_Bumon.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'Bumon'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','部門番号','分類番号','部門・分類名称','表示/非表示','flag16','登録時間');

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->Bumon->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}


	public function upload_menu(){		//EXCELL UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/MenuMSTR/MenuMSTR.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','order_no','cat1','cat2','photo_no','menu_name',
						'unitprice1','unitprice2','unitprice3','unitprice4','unitprice5',
						'unitprice6','unitprice7','unitprice8','unitprice9','unitprice10',
						'drink_free_kind8','menu_flag','flag16','up_date');
					$data = $this->ReadExcell($file_path, $fields);

					$this->MenuMSTR->truncate();
					$this->MenuMSTR->saveAll($data);
					$this->redirect(array('controller' => 'kara', 'action' => 'menu'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
/*
//debug($menu_id);
		if($menu_id > 0){
			$conditions = array('id'=>$menu_id);
			$data = $this->MenuMSTR->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
*/
	}



	public function upload_bumon(){		//EXCELL UPLOAD
		$error_msg = "";
		$this->set('main_title', "メニュー管理(マスター)".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/Bumon/Bumon.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					$fields = array('id','cat1','cat2','cat2name','cat2flag','flag16','up_date');
					$data = $this->ReadExcell($file_path, $fields);

					$this->Bumon->truncate();
					$this->Bumon->saveAll($data);
					$this->redirect(array('controller' => 'kara', 'action' => 'bumon'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}



/*
	public function download_staff(){
		$this->autoRender = false;	//View File なし

		$outputFile = date("YmdHi")."_Staff.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'Staff'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");

		/--------------------------------------------/
		$items = array('id','名前','有効/無効','更新日');
		/--------------------------------------------/

		$fields = array();
		$conditions = array();
		$group = array();
		$orders = array('id');
		$data = $this->Staff->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
		
		$this->download_sub($items, $data, $output_file_path, $outputFile);
	}
*/


	private function download_sub($items, $data, $output_file_path, $outputFile){
		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();
		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		//$book->getDefaultStyle()->getFont()->setName( 'ＭＳ ゴシック' );
		$book->getDefaultStyle()->getFont()->setName( 'HG丸ｺﾞｼｯｸM-PRO' );
		$book->getDefaultStyle()->getFont()->setSize( 12 );

 		//$sheet->setTitle(date("Y年m月d日 H時i分s秒"));
// 		$sheet->setTitle(date("Sheet1"));

		//=============================================================
		$row = 1;
		foreach ($items as $col => $value) {
        	$sheet->setCellValueByColumnAndRow($col+1, $row, $value);
			
			$objStyle = $sheet->getStyleByColumnAndRow($col+1, $row);	// スタイルオブジェクト取得([B2]セル)
			$objFill = $objStyle->getFill();	// フィルオブジェクト取得([B2]セル)
			$objFill->setFillType(Fill::FILL_SOLID);	// 背景のタイプを「塗つぶし」に設定
			$objFill->getStartColor()->setARGB('4000FF00');	// 背景色を「赤」に設定
		}


		$rowOffset = 2;
		for($i=0; $i<count($data); $i++){
			$data1 = $data[$i];
//debug($data1);
			$this->WriteExcel($sheet, $data1, $rowOffset);
			$rowOffset++;
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);
//exit();

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}



	private function WriteExcel($sheet, $data, $rowOffset){
		foreach ($data as $row => $fields) {
//debug($fields);
//debug($row);
//exit();
//		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 1;
			    foreach ($fields as $field => $value) {
//debug($col);
//debug($row);
//debug($rowOffset);
//debug($col);
//debug($value);
					
        			$sheet->setCellValueByColumnAndRow($col++, 0 + $rowOffset, $value);
//exit();
				}
//exit();
//    		}
		}
	}


/** ============================================================================================================= */
/*
	public function upload_staff(){		//EXCELL UPLOAD		RoomInfo		Staff
		$error_msg = "";
		$this->set('main_title', "スタッフ管理".$this->_server_name2);

//debug($this->request->data);			
		if($this->request->data){
			$file_name = $this->request->data['upload']['name'];
			$file_type = $this->request->data['upload']['type'];
			$tmp_name = $this->request->data['upload']['tmp_name'];
			$error = $this->request->data['upload']['error'];
			$file_size = $this->request->data['upload']['size'];

			if(strstr($this->request->data['submit'], "アップ")){
				if ($this->request->is('post')) {
					//保存先のパス
					$file_path = WWW_ROOT."files/Staff/Staff.xlsx";
//debug($path_file);
					move_uploaded_file($tmp_name, $file_path);		//$image['name']
					
					///==========================================
					$fields = array('id','name','flag','up_date');
					///==========================================
					$data = $this->ReadExcell($file_path, $fields);

					$this->Staff->truncate();
					$this->Staff->saveAll($data);
					$this->redirect(array('controller' => 'kara', 'action' => 'staff'));
				}
			}
//exit();
		}
		debug("エラー");
		exit();
	}


*/


	private function ReadExcell($file_path, $fields){
//debug($file_path);
//debug($fields);
//exit();
		if(!file_exists($file_path)){
			debug("ファイルが無い：".$file_path);
			exit();
		}
		
		$reader = new Reader();
		$spreadsheet = $reader->load($file_path); // ファイル名を指定

		$sheet = $spreadsheet->getActiveSheet();
		//$sheet = $spreadsheet->getSheetByName('Worksheet'); // 読み込むシートを指定
		//$sheet = $spreadsheet->getSheet(0);

		$lastrow = $sheet->getHighestRow(); //200などの数字
		$lastcolname = $sheet->getHighestColumn(); //AZなどの文字列
		$lastcol = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($lastcolname); //これで数字になる

//debug($lastrow);
//debug($lastcolname);
//debug($lastcol);
//debug(count($fields));
//exit();
		$data1 = array();
		for($row=2; $row<=$lastrow; $row++){
			for($col=1; $col<=$lastcol; $col++){
				$data1 = array_merge($data1, [$fields[$col-1] => $sheet->getCellByColumnAndRow($col,$row)->getValue()]);
			}
			$data1['id'] = $row - 1;
			$data[$row - 2] = $data1;
		}

/*
		$i = 0;
		$data = array();
		foreach ($sheet->getRowIterator() as $row) {
			$j = 0;
			$data1=array();
			foreach($sheet->getColumnIterator() as $column){
				$data1 = array_merge($data1, [$fields[$j] => $sheet->getCell($column->getColumnIndex() . ($row->getRowIndex()+1))->getValue()]);	//.PHP_EOL;
				$j++;
			}
			if($data1[$fields[2]] == null)
				break;
			$data1['id'] = $i+1;
			$data[$i] = $data1;
debug($data1);
debug($data[$i][$fields[2]]);
exit();
			$i++;
		}
*/

//debug($data[0]);
//debug($data[1]);
//debug($data[count($data)-2]);
//debug($data[count($data)-1]);
//exit();
		return $data;
		//PhpSpreadsheet
	}

/** ============================================================================================================= */
/** ============================================================================================================= */
/** ============================================================================================================= */






	private function ConvMember_id($member_list){
		if($member_list == "")
			return array(0, "");

		$members = explode('|', $member_list);
		$people = count($members);
		$member_id = "";
		$member_no = $name = array();
		if($people > 0){
			for($i=0; $i<$people; $i++){
				list($member_no[$i], $name[$i]) = explode('・', $members[$i]);
				$conditions = array('member_no' => $member_no[$i]);
				$m_id[$i] = $this->Member->field("id", $conditions, array('id DESC'));
			}
			$member_id = implode(",", $m_id);
		}
		return array($people, $member_id);
	}

///======================================================///

	private function session_proc(){
		$top_title = "";
		session_start();

		foreach ($_SESSION as $key => $value){
			$top_title .= $key."：".$value."　";
		}
		return $top_title;
	}



}
?>