<?php

//  https://p7.inabous.net/inabou/users/login

App::uses('AppController', 'Controller');

class UsersController extends AppController {
	public $name = 'Users';
	public $uses = array('User2');
	public $components = array(
		'Auth' => array(
			'authenticate' => array(
				'Form' => array(
					'fields' => array(
						//'username' => 'email', 
						'username' => 'username', 
						'password' => 'password', 
					), 
				)
			), 
			'loginAction' => '/users/login', 
			'loginRedirect' => '/users/index', 
			'logoutRedirect' => '/users/login'
		)
	);
	//public $layout = 'default2';
    public $layout = 'login';
	
	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

	public function beforeFilter(){
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);
		
		$main_title = "ログイン";
		$this->set('main_title', $main_title);
		
        $this->Auth->loginRedirect = array('controller' => 'users', 'action' => 'top_menu' ); // ログイン成功後のリダイレクト先
        $this->Auth->logoutRedirect = array(Configure::read('Routing.admin') => false, 'controller' => 'users', 'action' => 'login' ); // ログアウト後のリダイレクト先

	}

	public function index(){
	}
	
	public function login(){
		$main_title = "ログイン";
		$this->set('main_title', $main_title);

		//$this->log(array('first_name' => 'Tomoki', 'family_name' => 'HASEGAWA'));
		$errors = array();
		if ($this->request->data){
//debug($this->request->data);
/*
$data = $this->User2->find('first', array('conditions' => array('username LIKE' => $this->request->data['User']['username'])));
//debug($data);
$password2 = $data['User2']['password2'];

debug($this->request->data['User']['username']);
debug($password2);
//debug("MD5：".hash('md5', $password2));
debug("SHA-1：".hash('sha1', $password2));
//debug("SHA-256：".hash('sha256', $password2));
*/
			if ($this->Auth->login()){
//debug($this->Auth->redirectUrl());
//debug($logoutUrl);
//debug($this->Auth->user());
				//return $this->redirect($this->Auth->redirectUrl());
				$this->redirect($this->Auth->loginRedirect);
				exit();
			} else {
				$errors[] = 'メールアドレスかパスワードが違います。';
			}
		}
		$this->set('errors', $errors);
	}
	
	public function logout(){
		$this->redirect($this->Auth->logoutRedirect);
	}

	public function top_menu($button2=""){
		$main_title = "Top Menu";
		$this->set('main_title', $main_title);

//debug($this->Auth->user());
		$button2 = "";
		if ($this->request->data){
debug($this->request->data);
			$button2 = $this->request->data['User']['button2'];
		}

		if($button2 == "納品書"){
			$this->redirect(array('controller'=>'delivery','action'=>'index2', 'delivery/2021'));

		}elseif($button2 == "商品単価検索"){
			$this->redirect(array('controller'=>'search','action'=>'index', ''));

		}elseif(strstr( $button2, "通行料金")){
			$this->redirect(array('controller'=>'trafficfee','action'=>'search', 'trafficfee/2020' ));
		}elseif(strstr( $button2, "発注書")){
			$this->redirect(array('controller'=>'purchase','action'=>'search', 'purchase/2020' ));
		}elseif(strstr( $button2, "カメラ撮影記録")){
			$this->redirect(array('controller'=>'camera','action'=>'index', '' ));

		}elseif(strstr( $button2, "ドライブ運航記録")){
			$this->redirect(array('controller'=>'kitaro','action'=>'index', '' ));

		}elseif(strstr( $button2, "スケジュール管理(点検)") ){
			$this->redirect(array('controller'=>'schedulex','action'=>'index', 'schedulex/2021' ));
		}elseif(strstr( $button2, "スケジュール管理(工事)") ){
			$this->redirect(array('controller'=>'scheduley','action'=>'index', 'scheduley/2021' ));

		}elseif(strstr( $button2, "請求書")){
			$this->redirect(array('controller'=>'invoice','action'=>'search2', 'invoice/2020' ));
		}elseif(strstr( $button2, "仕入れ")){
			$this->redirect(array('controller'=>'sinvoice','action'=>'search2', '' ));

		}elseif(strstr( $button2, "見積書")){
			$this->redirect(array('controller'=>'quotation','action'=>'index', 'quotation/2020' ));
		}elseif(strstr($button2, "工事報告書")){
			$this->redirect(array('controller'=>'workreport','action'=>'index', 'workreport/2020' ));

		}elseif(strstr($button2, "棚卸明細")){
			$this->redirect(array('controller'=>'inventory','action'=>'search', 'inventory/2020' ));
		}elseif(strstr($button2, "ファイル転送")){
			$this->redirect(array('controller'=>'storage','action'=>'index', '' ));

		}elseif(strstr( $button2, "アクセス・ログ")){
			$this->redirect(array('controller'=>'quotation','action'=>'accesslogs', 'accesslogs' ));
		}elseif(strstr( $button2, "ログイン設定")){
//debug($button2);
			$this->redirect(array('controller'=>'mailauth','action'=>'login_pass', $this->Auth->user('id') ));
			//$this->login_pass($this->Auth->user('id'));
		}elseif($button2 == "ログアウト"){
			$this->redirect(array('controller'=>'users','action'=>'login' ));
		}
	
		$this->set('auth', 	$this->Auth);	//$auth->user('username')
	
	}

}
